// MainSheet.cpp : implementation file
//

#include "stdafx.h"
#include <winspool.h>
#include "DTC_C++Demo.h"
#include "MainSheet.h"

//#############################################################################

// CMainSheet

IMPLEMENT_DYNAMIC(CMainSheet, CPropertySheet)

CMainSheet::CMainSheet(UINT nIDCaption, CWnd* pParentWnd, UINT iSelectPage)
	:CPropertySheet(nIDCaption, pParentWnd, iSelectPage)
{
	//Hide the 'Apply' button
    m_psh.dwFlags |= PSH_NOAPPLYNOW;
}

CMainSheet::CMainSheet(LPCTSTR pszCaption, CWnd* pParentWnd, UINT iSelectPage)
	:CPropertySheet(pszCaption, pParentWnd, iSelectPage)
{
	//Hide the 'Apply' button
    m_psh.dwFlags |= PSH_NOAPPLYNOW;
}

CMainSheet::~CMainSheet()
{
}

BEGIN_MESSAGE_MAP(CMainSheet, CPropertySheet)
	ON_WM_NCCREATE()
END_MESSAGE_MAP()

//#############################################################################

// MainSheet message handlers
//
// Message handler for when user initializes dialog
//
BOOL CMainSheet::OnInitDialog()
{
	BOOL bResult = CPropertySheet::OnInitDialog();

	CWnd* pCANCELButton = GetDlgItem(IDCANCEL);
	ASSERT(pCANCELButton);
	pCANCELButton->ShowWindow(SW_HIDE);

	CWnd *pHelpBtn = GetDlgItem(IDHELP);
	ASSERT(pHelpBtn);
	pHelpBtn->ShowWindow(SW_HIDE);

	CRect rcBtn, rcDlg;
	GetWindowRect(&rcDlg);

	CButton *pBtn = (CButton*)GetDlgItem(IDOK);
	pBtn->GetWindowRect(&rcBtn);
	ScreenToClient(&rcBtn);
	int nOffset = (rcDlg.Width() - 24) - rcBtn.right; //Move it 2 Button positions right
	rcBtn.OffsetRect(nOffset, 0);
	pBtn->MoveWindow(&rcBtn, TRUE /*fRepaint*/);

	SetDlgItemText(IDOK, _T("Exit"));		//Change caption to 'Exit'

	// add the minimize button to the window
	::SetWindowLong(m_hWnd, GWL_STYLE, GetStyle() | WS_MINIMIZEBOX);

	return bResult;
}

//****************************************************************************

BOOL CMainSheet::OnNcCreate(LPCREATESTRUCT lpCreateStruct)
{
    if (!CPropertySheet::OnNcCreate(lpCreateStruct))
        return FALSE;

    // Modify the window style
    LONG dwStyle = ::GetWindowLong(m_hWnd, GWL_STYLE);
    ::SetWindowLong(m_hWnd, GWL_STYLE, dwStyle | WS_MINIMIZEBOX | WS_MAXIMIZEBOX);

    return TRUE;
}

//****************************************************************************

CString CMainSheet::HandleError
(
	int Error
)
{
	//Returns the string corresponding to the given error code
	switch (Error)
	{
	case ID_TIMEOUT:             return _T("ID_TIMEOUT");
	case ID_ERROR:               return _T("ID_ERROR");
	case ID_PRINTER_ERROR:       return _T("ID_PRINTER_ERROR");
	case ID_DRIVER_NOTCOMPLIANT: return _T("ID_DRIVER_NOTCOMPLIANT");
	case ID_OPENPRINTER_ERROR:   return _T("ID_OPENPRINTER_ERROR");
	case ID_REMOTECOMM_ERROR:    return _T("ID_REMOTECOMM_ERROR");
	case ID_LOCALCOMM_ERROR:     return _T("ID_LOCALCOMM_ERROR");
	case ID_SPOOLER_NOT_EMPTY:   return _T("ID_SPOOLER_NOT_EMPTY");
	case ID_SESSION_ACTIVE:      return _T("ID_SESSION_ACTIVE");
	case ID_LOCALCOMM_IN_USE:    return _T("ID_LOCALCOMM_IN_USE");
	case ID_PARAM_ERROR:         return _T("ID_PARAM_ERROR");
	case ID_INVALID_SESSION:     return _T("ID_INVALID_SESSION");
	case ID_MORE_DATA:           return _T("ID_MORE_DATA");
	case ID_INVALID_PRINTER:     return _T("ID_INVALID_PRINTER");
	case ID_INVALID_ACTION:      return _T("ID_INVALID_ACTION");
	case ID_NO_MAG_DATA:         return _T("ID_NO_MAG_DATA");
	case ID_NO_APDU_DATA:		 return _T("ID_NO_APDU_DATA");
	default:		             return _T("Unknown SDK Error");
	}
}

//****************************************************************************

CString CMainSheet::CorrectionString(int Correction)
{
	//Return the string corresponding to the given Colour Correction value
	switch (Correction)
	{
	case ID_NONE:            return _T("None");
	case ID_GAMMA1:          return _T("Gamma 1");
	case ID_GAMMA2:          return _T("Gamma 2");
	case ID_ICC_INTERNAL:    return _T("ICC Internal");
	case ID_ICC_EXTERNAL:    return _T("ICC External");
	case ID_PERCEPTUAL:      return _T("Perceptual");
	case ID_SATURATION:      return _T("Saturation");
	case ID_RELCOLORIMETRIC: return _T("Rel. Colorimetric");
	case ID_ABSCOLORIMETRIC: return _T("Abs. Colorimetric");
	default:                 return _T("**Undefined**");
	}
}

//****************************************************************************

CString CMainSheet::EraseSpeedString(ID_ERASESPEED Speed)
{
	switch (Speed)
	{
	case ID_ERASE_THOROUGH: return _T("Thorough");
	case ID_ERASE_QUICK:    return _T("Quick");
	default:                return _T("**Undefined**");
	}
}

//****************************************************************************

CString CMainSheet::EnabledDisabledString(BOOL State)
{
	return State ? _T("Enabled") : _T("Disabled");
}

//****************************************************************************

CString CMainSheet::OnOffString(int State)
{
	return (State != 0) ? _T("On") : _T("Off");
}

//****************************************************************************

CString CMainSheet::SideString(int Side)
{
	return Side ? _T("Back") : _T("Front");
}

//****************************************************************************

CString CMainSheet::Separator(ID_READWRITE Action)
{
	return (Action == ID_READ) ? _T(": ") : _T(" -> ");
}

//****************************************************************************

int CMainSheet::MaxCardWidth()
{
	return (PrinterType == ID_GENERATION2) ? PRO360_CARD_WIDTH : MAX_CARD_WIDTH;
}

//****************************************************************************

int CMainSheet::MaxCardHeight()
{
	return MAX_CARD_HEIGHT;
}

//****************************************************************************

int CMainSheet::MaxXCoord()
{
	return MaxCardWidth() - 1;
}

//****************************************************************************

int CMainSheet::MaxYCoord()
{
	return MaxCardHeight() - 1;
}

//****************************************************************************

void CMainSheet::AddString
(
	CEdit *pControl,
	CString str
)
{
	//Function to update the specified message box

	//Get the initial text length
	int nLength = pControl->GetWindowTextLength();

	//Add CR/LF to text
	CString strLine;
	strLine.Format(_T("%s\r\n"), str);

	//Put the selection at the end of text
	pControl->SetSel(nLength, nLength);

	//Replace the selection
	pControl->ReplaceSel(strLine);
}

//****************************************************************************

ID_RETURN CMainSheet::WaitForPrinterToFinish()
{
	if (PrintToFile)
		return ID_SUCCESS;

	//No Wait required for Generation 2 printers
	if (PrinterType == ID_GENERATION2)
		return ID_SUCCESS;

	CWaitCursor wait;
	ID_RETURN iResult;

	//Get SDK function address
	PFNIDWAIT pFnWaitForPrinter = (PFNIDWAIT)GetProcAddress(hLib, "ID_WaitForPrinter");
	if (!pFnWaitForPrinter)
	{
		FUNCTION_NOT_ACCESSED(WaitForPrinter);
		return ID_ERROR;
	}

	do
	{
		//Repeat the wait until response is not 'timeout'
		iResult = (*pFnWaitForPrinter)(hSession);
	} while (iResult == ID_TIMEOUT);

	return iResult;
}